/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.renderable.SocketLabel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;

class ConnectorTag {
    private double zoom = 1.0;
    private SocketLabel label;
    private Point aLoc = new Point(0, 0);
    private BlockConnector connector;
    private Dimension dimension = null;

    ConnectorTag(BlockConnector connector) {
        this.connector = connector;
    }

    void setZoomLevel(double newZoom) {
        this.zoom = newZoom;
        if (this.label != null) {
            this.label.setZoomLevel(newZoom);
        }
    }

    private int rescale(int x) {
        return (int)((double)x * this.zoom);
    }

    BlockConnector getSocket() {
        return this.connector;
    }

    void setSocket(BlockConnector conn) {
        this.connector = conn;
    }

    void setLabel(SocketLabel label) {
        this.label = label;
    }

    SocketLabel getLabel() {
        return this.label;
    }

    void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    Dimension getDimension() {
        if (this.dimension == null) {
            return null;
        }
        return new Dimension((int)((double)this.dimension.width / this.zoom), (int)((double)this.dimension.height / this.zoom));
    }

    void setAbstractLocation(Point2D p) {
        this.aLoc = new Point((int)p.getX(), (int)p.getY());
    }

    Point getAbstractLocation() {
        return this.aLoc.getLocation();
    }

    Point getPixelLocation() {
        return new Point(this.rescale(this.aLoc.x), this.rescale(this.aLoc.y));
    }
}

