/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui;

import com.ardublock.core.Context;
import com.ardublock.ui.listener.ArdublockWorkspaceListener;
import com.ardublock.ui.listener.GenerateCodeButtonListener;
import com.ardublock.ui.listener.NewButtonListener;
import com.ardublock.ui.listener.OpenButtonListener;
import com.ardublock.ui.listener.OpenblocksFrameListener;
import com.ardublock.ui.listener.SaveAsButtonListener;
import com.ardublock.ui.listener.SaveButtonListener;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OpenblocksFrame
extends JFrame {
    private static final long serialVersionUID = 2841155965906223806L;
    private Context context = Context.getContext();
    private JFileChooser fileChooser;
    private JFileChooser CfileChooser;
    private FileFilter ffilter;
    private ResourceBundle uiMessageBundle;

    public void addListener(OpenblocksFrameListener ofl) {
        this.context.registerOpenblocksFrameListener(ofl);
    }

    public String makeFrameTitle() {
        String title = "ArduBlock " + this.context.getSaveFileName();
        if (this.context.isWorkspaceChanged()) {
            title = title + " *";
        }
        return title;
    }

    public OpenblocksFrame() {
        this.setTitle(this.makeFrameTitle());
        this.setSize(new Dimension(1024, 760));
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
        this.fileChooser = new JFileChooser();
        this.ffilter = new FileNameExtensionFilter(this.uiMessageBundle.getString("ardublock.file.suffix"), "abp");
        this.fileChooser.setFileFilter(this.ffilter);
        this.fileChooser.addChoosableFileFilter(this.ffilter);
        this.CfileChooser = new JFileChooser();
        FileNameExtensionFilter cfilter = new FileNameExtensionFilter(this.uiMessageBundle.getString("ardublock.file.suffixc"), "ino");
        this.CfileChooser.setFileFilter(cfilter);
        this.CfileChooser.addChoosableFileFilter(cfilter);
        this.initOpenBlocks();
    }

    private void initOpenBlocks() {
        final Context context = Context.getContext();
        final Workspace workspace = context.getWorkspace();
        workspace.addWorkspaceListener(new ArdublockWorkspaceListener(this));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        JButton newButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.new"));
        newButton.addActionListener(new NewButtonListener(this));
        JButton saveButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.save"));
        saveButton.addActionListener(new SaveButtonListener(this));
        JButton saveAsButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.saveAs"));
        saveAsButton.addActionListener(new SaveAsButtonListener(this));
        JButton openButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.load"));
        openButton.addActionListener(new OpenButtonListener(this));
        JButton generateButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.upload"));
        generateButton.addActionListener(new GenerateCodeButtonListener(this, context));
        JButton serialMonitorButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.serialMonitor"));
        serialMonitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                context.getEditor().handleSerial();
            }
        });
        JButton saveImageButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.saveImage"));
        saveImageButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension size = workspace.getCanvasSize();
                System.out.println("size: " + size);
                BufferedImage bi = new BufferedImage(2560, 2560, 1);
                Graphics2D g = bi.createGraphics();
                double theScaleFactor = 4.166666666666667;
                g.scale(theScaleFactor, theScaleFactor);
                workspace.getBlockCanvas().getPageAt(0).getJComponent().paint(g);
                try {
                    JFileChooser fc = new JFileChooser();
                    fc.setSelectedFile(new File("ardublock.png"));
                    int returnVal = fc.showSaveDialog(workspace.getBlockCanvas().getJComponent());
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        ImageIO.write((RenderedImage)bi, "png", file);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    g.dispose();
                }
            }
        });
        buttons.add(newButton);
        buttons.add(saveButton);
        buttons.add(saveAsButton);
        buttons.add(openButton);
        buttons.add(generateButton);
        buttons.add(serialMonitorButton);
        JPanel bottomPanel = new JPanel();
        JButton websiteButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.website"));
        websiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        URL url = new URL("http://ardublock.com");
                        desktop.browse(url.toURI());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JLabel versionLabel = new JLabel("v " + this.uiMessageBundle.getString("ardublock.ui.version"));
        bottomPanel.add(saveImageButton);
        bottomPanel.add(websiteButton);
        bottomPanel.add(versionLabel);
        this.add((Component)buttons, "North");
        this.add((Component)bottomPanel, "South");
        this.add((Component)workspace, "Center");
    }

    public void doOpenArduBlockFile() {
        if (this.context.isWorkspaceChanged()) {
            int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.content.open_unsaved"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
            if (optionValue == 0) {
                this.doSaveArduBlockFile();
                this.loadFile();
            } else if (optionValue == 1) {
                this.loadFile();
            }
        } else {
            this.loadFile();
        }
        this.setTitle(this.makeFrameTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile() {
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File savedFile = this.fileChooser.getSelectedFile();
            if (!savedFile.exists()) {
                JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.file_not_found"), this.uiMessageBundle.getString("message.title.error"), 0, 0, null, null, 0);
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.context.loadArduBlockFile(savedFile);
                this.context.setWorkspaceChanged(false);
            }
            catch (IOException e) {
                JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.file_not_found"), this.uiMessageBundle.getString("message.title.error"), 0, 0, null, null, 0);
                e.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public boolean doSaveArduBlockFile() {
        if (!this.context.isWorkspaceChanged()) {
            return true;
        }
        String saveString = this.getArduBlockString();
        if (this.context.getSaveFilePath() == null) {
            return this.chooseFileAndSave(saveString);
        }
        File saveFile = new File(this.context.getSaveFilePath());
        this.writeFileAndUpdateFrame(saveString, saveFile);
        return true;
    }

    public void doSaveAsArduBlockFile() {
        if (this.context.isWorkspaceEmpty()) {
            return;
        }
        String saveString = this.getArduBlockString();
        this.chooseFileAndSave(saveString);
    }

    public void doSaveAsArduCFile(String code) {
        if (this.context.isWorkspaceEmpty()) {
            return;
        }
        this.chooseFileAndSave(code, ".ino");
    }

    private boolean chooseFileAndSave(String ardublockString) {
        File saveFile = this.letUserChooseSaveFile();
        if ((saveFile = this.checkFileSuffix(saveFile)) == null) {
            return false;
        }
        if (saveFile.exists() && !this.askUserOverwriteExistedFile()) {
            return false;
        }
        this.writeFileAndUpdateFrame(ardublockString, saveFile);
        return true;
    }

    private boolean chooseFileAndSave(String input, String suffix) {
        File saveFile = this.letUserChooseCSaveFile();
        if ((saveFile = this.checkFileSuffix(saveFile, suffix)) == null) {
            return false;
        }
        if (saveFile.exists() && !this.askUserOverwriteExistedFile()) {
            return false;
        }
        this.writeFileAndUpdateFrame(input, saveFile);
        return true;
    }

    private String getArduBlockString() {
        WorkspaceController workspaceController = this.context.getWorkspaceController();
        return workspaceController.getSaveString();
    }

    private void writeFileAndUpdateFrame(String ardublockString, File saveFile) {
        try {
            this.saveArduBlockToFile(ardublockString, saveFile);
            this.context.setWorkspaceChanged(false);
            this.setTitle(this.makeFrameTitle());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File letUserChooseSaveFile() {
        int chooseResult = this.fileChooser.showSaveDialog(this);
        if (chooseResult == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    private File letUserChooseCSaveFile() {
        int chooseResult = this.CfileChooser.showSaveDialog(this);
        if (chooseResult == 0) {
            return this.CfileChooser.getSelectedFile();
        }
        return null;
    }

    private boolean askUserOverwriteExistedFile() {
        int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.content.overwrite"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
        return optionValue == 0;
    }

    private void saveArduBlockToFile(String ardublockString, File saveFile) throws IOException {
        this.context.saveArduBlockFile(saveFile, ardublockString);
        this.context.setSaveFileName(saveFile.getName());
        this.context.setSaveFilePath(saveFile.getAbsolutePath());
    }

    public void doNewArduBlockFile() {
        if (this.context.isWorkspaceChanged()) {
            int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.question.newfile_on_workspace_changed"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
            switch (optionValue) {
                case 0: {
                    this.doSaveArduBlockFile();
                }
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.context.resetWorksapce();
                    this.context.setWorkspaceChanged(false);
                    this.setTitle(this.makeFrameTitle());
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.context.resetWorksapce();
            this.context.setWorkspaceChanged(false);
            this.setTitle(this.makeFrameTitle());
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void doCloseArduBlockFile() {
        if (this.context.isWorkspaceChanged()) {
            int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.question.close_on_workspace_changed"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
            switch (optionValue) {
                case 0: {
                    if (this.doSaveArduBlockFile()) {
                        this.setDefaultCloseOperation(2);
                        break;
                    }
                    this.setDefaultCloseOperation(0);
                    break;
                }
                case 1: {
                    this.setDefaultCloseOperation(2);
                    break;
                }
                case 2: {
                    this.setDefaultCloseOperation(0);
                }
            }
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    private File checkFileSuffix(File saveFile) {
        String filePath = saveFile.getAbsolutePath();
        if (filePath.endsWith(".abp")) {
            return saveFile;
        }
        return new File(filePath + ".abp");
    }

    private File checkFileSuffix(File saveFile, String suffix) {
        String filePath = saveFile.getAbsolutePath();
        if (filePath.endsWith(suffix)) {
            return saveFile;
        }
        return new File(filePath + suffix);
    }
}

