/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.storage;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class EEPROMReadIntBlock
extends TranslatorBlock {
    public EEPROMReadIntBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    @Override
    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        EEPROMReadIntBlock.setupEEPROMEnvironment(this.translator);
        String ret = "eepromReadInt( ";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        ret = ret + tb.toCode() + " ) ";
        return this.codePrefix + ret + this.codeSuffix;
    }

    public static void setupEEPROMEnvironment(Translator t) {
        t.addHeaderFile("EEPROM.h");
        t.addDefinitionCommand("/********************************************************\nA way to read int (2 Bytes)from EEPROM \nEEPROM library natively supports only bytes\n********************************************************/\nint eepromReadInt(int address){\n\n\tunion u_tag {\n\t\tbyte b[2];\n\t\tint INTtime;\n\t} time;\n\ttime.b[0] = EEPROM.read(address);\n\ttime.b[1] = EEPROM.read(address+1);\n\treturn time.INTtime;\n}\n");
    }
}

