/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.IrGetCodeBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class IrSetPortBlock
extends TranslatorBlock {
    public IrSetPortBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    @Override
    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.registerBodyTranslateFinishCallback(this);
        IrGetCodeBlock.addIrBlockCount(this.translator);
        if (this.translator.getInternalData("irSetup") == null) {
            String def = this.getDefinitionCode().append("void __ab_setupIrReceiver()\n{\n  __ab_irrecv.enableIRIn();\n  __ab_irrecv.resume();\n}\nvoid __ab_getIrCommand(String &receivedCommand)\n{\n  decode_results result;\n  if (__ab_irrecv.decode(&result))\n  {\n    receivedCommand = String(result.value, HEX);\n    receivedCommand.toUpperCase();\n    __ab_irrecv.resume();\n  }\n  else\n  {\n    receivedCommand = \"\";\n  }\n}").toString();
            this.translator.addDefinitionCommand(def);
            this.translator.addInternalData("irSetup", new Object());
        }
        return "";
    }

    private StringBuilder getDefinitionCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        return IrSetPortBlock.getDefinitionCode(translatorBlock.toCode());
    }

    public static StringBuilder getDefinitionCode(String port) {
        StringBuilder ret = new StringBuilder();
        ret.append("IRrecv __ab_irrecv(");
        ret.append(port);
        ret.append(");\n");
        return ret;
    }

    @Override
    public void onTranslateBodyFinished() throws SocketNullException, SubroutineNotDeclaredException {
        IrGetCodeBlock.irBlockCallback(this.translator);
    }
}

