/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.IrSetPortBlock;
import com.ardublock.translator.block.MessageBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class IrGetCodeBlock
extends TranslatorBlock {
    public static final String IR_BLOCK_COUNT = "irBlockCnt";
    public static final String IR_BLOCK_CALLBACK_COUNT = "irBlockCallbackCnt";
    public static final String IR_SETUP = "irSetup";
    public static final String IR_DEFINITION = "void __ab_setupIrReceiver()\n{\n  __ab_irrecv.enableIRIn();\n  __ab_irrecv.resume();\n}\nvoid __ab_getIrCommand(String &receivedCommand)\n{\n  decode_results result;\n  if (__ab_irrecv.decode(&result))\n  {\n    receivedCommand = String(result.value, HEX);\n    receivedCommand.toUpperCase();\n    __ab_irrecv.resume();\n  }\n  else\n  {\n    receivedCommand = \"\";\n  }\n}";

    public IrGetCodeBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    @Override
    public String toCode() throws SocketNullException, SubroutineNotDeclaredException, BlockException {
        IrGetCodeBlock.addIrBlockCount(this.translator);
        this.translator.registerBodyTranslateFinishCallback(this);
        this.translator.addHeaderFile("IRremote00.h");
        this.translator.addHeaderFile("ctype.h");
        this.translator.addHeaderFile("Wire.h");
        this.translator.addSetupCommand("__ab_setupIrReceiver();");
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        if (tb instanceof MessageBlock) {
            throw new BlockException(tb.blockId, "message cannot be override, choose string variable instead");
        }
        return this.codePrefix + "__ab_getIrCommand(" + tb.toCode() + ");\n" + this.codeSuffix;
    }

    public static void addIrBlockCount(Translator translator) {
        IrGetCodeBlock.increaseInternalData(translator, IR_BLOCK_COUNT);
    }

    public static void addIrBlockCallbackCount(Translator translator) {
        IrGetCodeBlock.increaseInternalData(translator, IR_BLOCK_CALLBACK_COUNT);
    }

    public static void increaseInternalData(Translator translator, String name) {
        Object o = translator.getInternalData(name);
        if (o == null) {
            Integer i = new Integer(1);
            translator.addInternalData(name, i);
        } else {
            Integer i = (Integer)o;
            i = i + 1;
            translator.addInternalData(name, i);
        }
    }

    public static boolean isLastIrBlock(Translator translator) {
        Integer registeredBlockCount = (Integer)translator.getInternalData(IR_BLOCK_COUNT);
        Integer currentBlockCount = (Integer)translator.getInternalData(IR_BLOCK_CALLBACK_COUNT);
        return registeredBlockCount.intValue() == currentBlockCount.intValue();
    }

    public static void irBlockCallback(Translator translator) {
        IrGetCodeBlock.addIrBlockCallbackCount(translator);
        if (IrGetCodeBlock.isLastIrBlock(translator) && translator.getInternalData(IR_SETUP) == null) {
            String def = IrSetPortBlock.getDefinitionCode("11").append(IR_DEFINITION).toString();
            translator.addDefinitionCommand(def);
        }
    }

    @Override
    public void onTranslateBodyFinished() {
        IrGetCodeBlock.irBlockCallback(this.translator);
    }
}

