/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.JComponentDragHandler;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.CTracklessScrollPane;
import edu.mit.blocks.renderable.CommentArrow;
import edu.mit.blocks.renderable.CommentLabel;
import edu.mit.blocks.renderable.CommentSource;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Comment
extends JPanel {
    private static final long serialVersionUID = 328149080425L;
    private static final Color background = new Color(255, 255, 150);
    private final Color borderColor;
    private JTextArea textArea;
    private CTracklessScrollPane scrollPane;
    private JComponentDragHandler jCompDH;
    private CommentArrow arrow;
    private UndoManager undoManager;
    private CommentSource commentSource;
    private CommentLabel commentLabel;
    private boolean constrainComment = true;
    static int FONT_SIZE = 14;
    static int MINIMUM_WIDTH = FONT_SIZE * 4;
    static int MINIMUM_HEIGHT = FONT_SIZE * 2;
    static int DEFAULT_WIDTH = 150;
    static int DEFAULT_HEIGHT = 100;
    private boolean resizing = false;
    private int margin = 6;
    private int width = DEFAULT_WIDTH;
    private int height = DEFAULT_HEIGHT;
    private double zoom = 1.0;
    private String fontname = "Monospaced";
    private Shape body;
    private Shape resize;
    private Shape textarea;
    private boolean pressed = false;
    private boolean active = false;
    private final Workspace workspace;

    public Comment(Workspace workspace, String initText, CommentSource source, Color borderColor, double zoom) {
        this.workspace = workspace;
        this.zoom = zoom;
        this.setLayout(null);
        this.setOpaque(false);
        this.setBounds(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.borderColor = borderColor;
        this.commentSource = source;
        this.textArea = new JTextArea(initText);
        this.textArea.setFont(new Font(this.fontname, 0, (int)((double)FONT_SIZE * zoom)));
        this.textArea.setForeground(Color.BLACK);
        this.textArea.setBackground(background);
        this.textArea.setCaretColor(Color.BLACK);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1000);
        this.textArea.getDocument().addUndoableEditListener(this.undoManager);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Comment.this.workspace.notifyListeners(new WorkspaceEvent(Comment.this.workspace, Comment.this.getCommentSource().getParentWidget(), 18));
                if (e.isControlDown() || (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    if (e.getKeyCode() == 90) {
                        try {
                            Comment.this.undoManager.undo();
                        }
                        catch (CannotUndoException cannotUndoException) {}
                    } else if (e.getKeyCode() == 89) {
                        try {
                            Comment.this.undoManager.redo();
                        }
                        catch (CannotRedoException cannotRedoException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.scrollPane = new CTracklessScrollPane(this.textArea, CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER, 10, this.borderColor, background);
        this.add((Component)this.scrollPane, 0);
        CommentEventListener eventListener = new CommentEventListener();
        this.jCompDH = new JComponentDragHandler(workspace, this);
        this.addMouseListener(eventListener);
        this.addMouseMotionListener(eventListener);
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Comment comment = Comment.this;
                comment.setPressed(true);
                comment.showOnTop();
            }
        });
        this.textArea.addFocusListener(eventListener);
        this.textArea.setEditable(true);
        this.reformComment();
        this.arrow = new CommentArrow(this);
        this.commentLabel = new CommentLabel(workspace, source.getBlockID());
        source.add(this.commentLabel);
        this.commentLabel.setActive(true);
        this.reformComment();
        workspace.notifyListeners(new WorkspaceEvent(workspace, this.getCommentSource().getParentWidget(), 13));
    }

    public void delete() {
        this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, this.getCommentSource().getParentWidget(), 14));
        this.getParent().remove(this.arrow.arrow);
        this.setParent(null);
        if (this.commentSource instanceof RenderableBlock) {
            RenderableBlock rb = (RenderableBlock)this.commentSource;
            rb.remove(this.commentLabel);
            this.commentLabel = null;
        }
    }

    CommentSource getCommentSource() {
        return this.commentSource;
    }

    CommentLabel getCommentLabel() {
        return this.commentLabel;
    }

    public int getCommentLabelWidth() {
        if (this.commentLabel == null) {
            return 0;
        }
        return this.commentLabel.getWidth();
    }

    public void update() {
        if (this.commentLabel != null) {
            this.setVisible(this.commentLabel.isActive());
            this.commentLabel.update();
            if (this.arrow.arrow != null) {
                this.arrow.setVisible(this.commentLabel.isActive());
            }
        }
    }

    public void update(boolean visibleState) {
        if (this.commentLabel != null) {
            this.commentLabel.setActive(visibleState);
        }
        this.update();
    }

    public void setZoomLevel(double newZoom) {
        this.zoom = newZoom;
        this.textArea.setFont(new Font(this.fontname, 0, (int)(12.0 * this.zoom)));
        if (this.commentLabel != null) {
            this.commentLabel.setZoomLevel(newZoom);
        }
        this.reformComment();
        this.getArrow().updateArrow();
    }

    public void reformComment() {
        int w = this.textArea.isEditable() ? (int)((double)this.width * this.zoom) : (int)((double)MINIMUM_WIDTH * this.zoom);
        int h = this.textArea.isEditable() ? (int)((double)this.height * this.zoom) : (int)((double)MINIMUM_HEIGHT * this.zoom);
        int m = (int)((double)this.margin * this.zoom);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo(m - 1, m - 1);
        path2.lineTo(w - m, m - 1);
        path2.lineTo(w - m, h - m);
        path2.lineTo(m - 1, h - m);
        path2.closePath();
        this.textarea = path2;
        this.body = new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 3 * m, 3 * m);
        GeneralPath path3 = new GeneralPath();
        path3.moveTo(w - 3 * m, h);
        path3.lineTo(w, h - 3 * m);
        path3.curveTo(w, h, w, h, w - 3 * m, h);
        this.resize = path3;
        this.scrollPane.setBounds(m, m, w - 2 * m, h - 2 * m);
        this.scrollPane.setThumbWidth(this.textArea.isEditable() ? 2 * m : 0);
        this.setBounds(this.getX(), this.getY(), w, h);
        this.revalidate();
        this.repaint();
        if (this.arrow != null) {
            this.arrow.updateArrow();
        }
    }

    private int descale(double x) {
        return (int)(x / this.zoom);
    }

    public Node getSaveNode(Document document) {
        Element commentElement = document.createElement("Comment");
        Element textElement = document.createElement("Text");
        Text text = document.createTextNode(this.getText().replaceAll("`", "'"));
        textElement.appendChild(text);
        commentElement.appendChild(textElement);
        Element locationElement = document.createElement("Location");
        Element xElement = document.createElement("X");
        xElement.appendChild(document.createTextNode(String.valueOf(this.descale(this.getLocation().getX()))));
        locationElement.appendChild(xElement);
        Element yElement = document.createElement("Y");
        yElement.appendChild(document.createTextNode(String.valueOf(this.descale(this.getLocation().getY()))));
        locationElement.appendChild(yElement);
        commentElement.appendChild(locationElement);
        Element boxSizeElement = document.createElement("BoxSize");
        Element widthElement = document.createElement("Width");
        widthElement.appendChild(document.createTextNode(String.valueOf(this.descale(this.getWidth()))));
        boxSizeElement.appendChild(widthElement);
        Element heightElement = document.createElement("Height");
        heightElement.appendChild(document.createTextNode(String.valueOf(this.descale(this.getHeight()))));
        boxSizeElement.appendChild(heightElement);
        commentElement.appendChild(boxSizeElement);
        if (!this.commentLabel.isActive()) {
            Element collapsedElement = document.createElement("Collapsed");
            commentElement.appendChild(collapsedElement);
        }
        return commentElement;
    }

    public static Comment loadComment(Workspace workspace, NodeList commentChildren, RenderableBlock rb) {
        Comment comment = null;
        boolean commentCollapsed = false;
        String text = null;
        Point commentLoc = new Point(0, 0);
        Dimension boxSize = new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        for (int j = 0; j < commentChildren.getLength(); ++j) {
            Node commentChild = commentChildren.item(j);
            if (commentChild.getNodeName().equals("Text")) {
                text = commentChild.getTextContent();
                continue;
            }
            if (commentChild.getNodeName().equals("Location")) {
                RenderableBlock.extractLocationInfo(commentChild, commentLoc);
                continue;
            }
            if (commentChild.getNodeName().equals("BoxSize")) {
                RenderableBlock.extractBoxSizeInfo(commentChild, boxSize);
                continue;
            }
            if (commentChild.getNodeName().equals("Collapsed")) {
                commentCollapsed = true;
                continue;
            }
            System.out.println("Uknown Comment Node: " + commentChild.getNodeName());
        }
        if (text != null) {
            comment = new Comment(workspace, text, rb, rb.getBlock().getColor(), rb.getZoom());
            comment.setLocation(commentLoc.x, commentLoc.y);
            comment.update(!commentCollapsed);
            comment.setMyWidth((int)boxSize.getWidth());
            comment.setMyHeight((int)boxSize.getHeight());
            comment.reformComment();
        }
        return comment;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        if (this.active) {
            g2.setColor(this.getBorderColor().brighter());
        } else {
            g2.setColor(this.getBorderColor());
        }
        g2.fill(this.body);
        if (this.active) {
            g2.setColor(background.brighter());
        } else {
            g2.setColor(background);
        }
        g2.fill(this.textarea);
        if (this.active) {
            g2.setColor(Color.white);
        } else {
            g2.setColor(Color.lightGray);
        }
        g2.draw(this.textarea);
        if (this.active) {
            g2.setColor(Color.lightGray.brighter());
        } else {
            g2.setColor(Color.lightGray);
        }
        g2.fill(this.resize);
        super.paint(g);
    }

    public String getText() {
        return this.textArea.getText().trim();
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.isConstrainComment() && this.getParent() != null) {
            if (y < 0) {
                y = 0;
            } else if (y + this.getHeight() > this.getParent().getHeight()) {
                y = Math.max(this.getParent().getHeight() - this.getHeight(), 0);
            }
            if (x < 0) {
                x = 0;
            } else if (x + this.getWidth() + 1 > this.getParent().getWidth()) {
                x = Math.max(this.getParent().getWidth() - this.getWidth() - 1, 0);
            }
        }
        super.setLocation(x, y);
        this.arrow.updateArrow();
        this.workspace.getMiniMap().repaint();
    }

    @Override
    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void translatePosition(int dx, int dy) {
        this.setLocation(this.getX() + dx, this.getY() + dy);
    }

    public void setParent(Container newparent) {
        this.setParent(newparent, 0);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.arrow.arrow != null) {
            this.arrow.setVisible(b);
        }
    }

    public void setParent(Container newparent, Object constraints) {
        Container oldParent = this.getParent();
        if (oldParent != null) {
            oldParent.remove(this);
            oldParent.remove(this.arrow.arrow);
            oldParent.validate();
            oldParent.repaint();
        }
        if (newparent != null) {
            if (constraints == null) {
                newparent.add((Component)this, 0);
            } else {
                newparent.add((Component)this, constraints);
            }
            this.arrow.updateArrow();
            newparent.validate();
            newparent.repaint();
        }
    }

    @Override
    public String toString() {
        return "Comment ID:  at " + this.getLocation() + " with text: \"" + this.getText() + "\"";
    }

    public void showOnTop() {
        if (this.getParent() != null) {
            this.getParent().setComponentZOrder(this, 0);
        }
    }

    Color getBackgroundColor() {
        return background;
    }

    Color getBorderColor() {
        return this.borderColor;
    }

    public CommentArrow getArrow() {
        return this.arrow;
    }

    int getMyWidth() {
        return this.width;
    }

    void setMyWidth(int width) {
        this.width = width;
    }

    int getMyHeight() {
        return this.height;
    }

    void setMyHeight(int height) {
        this.height = height;
    }

    int getMargin() {
        return this.margin;
    }

    void setMargin(int margin) {
        this.margin = margin;
    }

    boolean isPressed() {
        return this.pressed;
    }

    void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    boolean isResizing() {
        return this.resizing;
    }

    void setResizing(boolean resizing) {
        this.resizing = resizing;
    }

    public boolean isConstrainComment() {
        return this.constrainComment;
    }

    public void setConstrainComment(boolean constrainComment) {
        this.constrainComment = constrainComment;
    }

    private class CommentEventListener
    implements FocusListener,
    MouseListener,
    MouseMotionListener {
        private CommentEventListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Comment.this.active = true;
            Comment.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Comment.this.active = false;
            Comment.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Comment.this.showOnTop();
            Comment.this.jCompDH.mouseEntered(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (Comment.this.textArea.isEditable()) {
                if (e.getX() > Comment.this.width - 2 * Comment.this.margin && e.getY() > Comment.this.height - 2 * Comment.this.margin) {
                    Comment.this.setCursor(new Cursor(5));
                } else {
                    Comment.this.jCompDH.mouseMoved(e);
                }
            } else {
                Comment.this.jCompDH.mouseMoved(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Comment.this.jCompDH.mouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Comment.this.grabFocus();
            Comment.this.showOnTop();
            Comment.this.jCompDH.mousePressed(e);
            if (Comment.this.textArea.isEditable()) {
                if (e.getX() > Comment.this.width - 2 * Comment.this.margin && e.getY() > Comment.this.height - 2 * Comment.this.margin) {
                    Comment.this.setResizing(true);
                } else if (e.getY() < Comment.this.margin) {
                    Comment.this.setPressed(true);
                }
            } else if (e.getY() < Comment.this.margin) {
                Comment.this.setPressed(true);
            }
            Comment.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Comment.this.jCompDH.mouseReleased(e);
            Comment.this.setResizing(false);
            Comment.this.setPressed(false);
            Comment.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (Comment.this.isResizing()) {
                double ww = (double)e.getX() > (double)MINIMUM_WIDTH * Comment.this.zoom ? (double)e.getX() : (double)MINIMUM_WIDTH * Comment.this.zoom;
                double hh = (double)e.getY() > (double)MINIMUM_HEIGHT * Comment.this.zoom ? (double)e.getY() : (double)MINIMUM_HEIGHT * Comment.this.zoom;
                Comment.this.width = (int)ww;
                Comment.this.height = (int)hh;
                Comment.this.reformComment();
                Comment.this.workspace.notifyListeners(new WorkspaceEvent(Comment.this.workspace, Comment.this.getCommentSource().getParentWidget(), 16));
            } else {
                Comment.this.jCompDH.mouseDragged(e);
                Comment.this.arrow.updateArrow();
                Comment.this.workspace.notifyListeners(new WorkspaceEvent(Comment.this.workspace, Comment.this.getCommentSource().getParentWidget(), 15));
            }
        }
    }
}

