/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui.listener;

import com.ardublock.core.Context;
import com.ardublock.translator.AutoFormat;
import com.ardublock.translator.Translator;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNameDuplicatedException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import com.ardublock.ui.OpenblocksFrame;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GenerateCodeButtonListener
implements ActionListener {
    private JFrame parentFrame;
    private Context context;
    private Workspace workspace;
    private ResourceBundle uiMessageBundle;

    public GenerateCodeButtonListener(JFrame frame, Context context) {
        this.parentFrame = frame;
        this.context = context;
        this.workspace = context.getWorkspaceController().getWorkspace();
        this.uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterable<RenderableBlock> blocks;
        Long blockId;
        boolean success = true;
        Translator translator = new Translator(this.workspace);
        translator.reset();
        Iterable<RenderableBlock> renderableBlocks = this.workspace.getRenderableBlocks();
        HashSet<RenderableBlock> loopBlockSet = new HashSet<RenderableBlock>();
        HashSet<RenderableBlock> subroutineBlockSet = new HashSet<RenderableBlock>();
        HashSet<RenderableBlock> scoopBlockSet = new HashSet<RenderableBlock>();
        HashSet guinoBlockSet = new HashSet();
        StringBuilder code = new StringBuilder();
        for (RenderableBlock renderableBlock : renderableBlocks) {
            String functionName;
            Block block = renderableBlock.getBlock();
            if (block.getGenusName().equals("DuinoEDU_Guino_Read")) {
                translator.setGuinoProgram(true);
            }
            if (block.getGenusName().equals("DuinoEDU_Guino_Title") || block.getGenusName().equals("DuinoEDU_Guino_Slider") || block.getGenusName().equals("DuinoEDU_Guino_column") || block.getGenusName().equals("DuinoEDU_Guino_switch") || block.getGenusName().equals("DuinoEDU_Guino_pause")) {
                translator.setGuinoProgram(true);
            }
            if (block.hasPlug() || !Block.NULL.equals(block.getBeforeBlockID())) continue;
            if (block.getGenusName().equals("loop")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("loop1")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("loop2")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("loop3")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("program")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("setup")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("subroutine")) {
                functionName = block.getBlockLabel().trim();
                try {
                    translator.addFunctionName(block.getBlockID(), functionName);
                }
                catch (SubroutineNameDuplicatedException e1) {
                    this.context.highlightBlock(renderableBlock);
                    JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNameDuplicated"), "Error", 0);
                    return;
                }
                subroutineBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("subroutine_var")) {
                functionName = block.getBlockLabel().trim();
                try {
                    translator.addFunctionName(block.getBlockID(), functionName);
                }
                catch (SubroutineNameDuplicatedException e1) {
                    this.context.highlightBlock(renderableBlock);
                    JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNameDuplicated"), "Error", 0);
                    return;
                }
                subroutineBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("scoop_task")) {
                translator.setScoopProgram(true);
                scoopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("scoop_loop")) {
                translator.setScoopProgram(true);
                scoopBlockSet.add(renderableBlock);
            }
            if (!block.getGenusName().equals("scoop_pin_event")) continue;
            translator.setScoopProgram(true);
            scoopBlockSet.add(renderableBlock);
        }
        if (loopBlockSet.size() == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.noLoopFound"), "Error", 0);
            return;
        }
        if (loopBlockSet.size() > 1) {
            for (RenderableBlock rb : loopBlockSet) {
                this.context.highlightBlock(rb);
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.multipleLoopFound"), "Error", 0);
            return;
        }
        try {
            for (RenderableBlock renderableBlock : loopBlockSet) {
                translator.setRootBlockName("loop");
                Block loopBlock = renderableBlock.getBlock();
                code.append(translator.translate(loopBlock.getBlockID()));
            }
            for (RenderableBlock renderableBlock : scoopBlockSet) {
                translator.setRootBlockName("scoop");
                Block scoopBlock = renderableBlock.getBlock();
                code.append(translator.translate(scoopBlock.getBlockID()));
            }
            for (RenderableBlock renderableBlock : guinoBlockSet) {
                translator.setRootBlockName("guino");
                Block guinoBlock = renderableBlock.getBlock();
                code.append(translator.translate(guinoBlock.getBlockID()));
            }
            for (RenderableBlock renderableBlock : subroutineBlockSet) {
                translator.setRootBlockName("subroutine");
                Block subroutineBlock = renderableBlock.getBlock();
                code.append(translator.translate(subroutineBlock.getBlockID()));
            }
            translator.beforeGenerateHeader();
            code.insert(0, translator.genreateHeaderCommand());
        }
        catch (SocketNullException e1) {
            e1.printStackTrace();
            success = false;
            blockId = e1.getBlockId();
            blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock2 : blocks) {
                Block block2 = renderableBlock2.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock2);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.socketNull"), "Error", 0);
        }
        catch (BlockException e2) {
            e2.printStackTrace();
            success = false;
            blockId = e2.getBlockId();
            blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock2 : blocks) {
                Block block2 = renderableBlock2.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock2);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, e2.getMessage(), "Error", 0);
        }
        catch (SubroutineNotDeclaredException e3) {
            e3.printStackTrace();
            success = false;
            blockId = e3.getBlockId();
            blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock3 : blocks) {
                Block block2 = renderableBlock3.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock3);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNotDeclared"), "Error", 0);
        }
        if (success) {
            AutoFormat formatter = new AutoFormat();
            String codeOut = code.toString();
            Objects.requireNonNull(this.context);
            codeOut = formatter.format(codeOut);
            if (!this.context.isInArduino()) {
                OpenblocksFrame frame = (OpenblocksFrame)this.parentFrame;
                System.out.println(codeOut);
                frame.doSaveAsArduCFile(codeOut);
            }
            this.context.didGenerate(codeOut);
        }
    }
}

