/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.storage;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class EEPROMWriteIntBlock
extends TranslatorBlock {
    public EEPROMWriteIntBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    @Override
    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        EEPROMWriteIntBlock.setupEEPROMEnvironment(this.translator);
        String ret = "eepromWriteInt( ";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        ret = ret + tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        ret = "\t" + ret + " , " + tb.toCode() + " ) ;\n";
        return this.codePrefix + ret + this.codeSuffix;
    }

    private static void setupEEPROMEnvironment(Translator t) {
        t.addHeaderFile("EEPROM.h");
        t.addDefinitionCommand("/*******************************************************************\nA way to write an 'int' (2 Bytes) to EEPROM \nEEPROM library natively supports only bytes. \nNote it takes around 8ms to write an int to EEPROM \n*******************************************************************/\nvoid eepromWriteInt(int address, int value){\n\tunion u_tag {\n\t\tbyte b[2];        //assumes 2 bytes in an int\n\t\tint INTtime;\n\t} time;\n\ttime.INTtime=value;\n\t\n\tEEPROM.write(address  , time.b[0]); \n\tEEPROM.write(address+1, time.b[1]); \n}\n");
    }
}

