/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.panda;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;

public class PandaInputPortBlock
extends TranslatorBlock {
    public int[][] pinTable = new int[][]{{0, 0}, {0, 8}, {1, 9}, {4, 10}};

    public PandaInputPortBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    @Override
    public String toCode() throws SocketNullException {
        String g_name = this.getTranslator().getBlock(this.blockId).getGenusName();
        String port_str = g_name.substring(7);
        int port = Integer.parseInt(port_str);
        int pin = this.pinTable[port][0];
        int led_pin = this.pinTable[port][1];
        this.translator.addSetupCommand("pinMode(" + pin + ", INPUT);");
        this.translator.addSetupCommand("pinMode(" + led_pin + ", OUTPUT);");
        this.translator.addSetupCommand("digitalWrite(" + led_pin + ", HIGH);");
        return "A" + pin + "";
    }
}

