/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.VariableNumberBlock;
import com.ardublock.translator.block.VariableNumberDoubleBlock;
import com.ardublock.translator.block.VariableNumberUnsignedLongBlock;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import java.util.ResourceBundle;

public class RepeatControlBlock
extends TranslatorBlock {
    private static ResourceBundle uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");

    public RepeatControlBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator);
    }

    @Override
    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        if (!(tb instanceof VariableNumberBlock || tb instanceof VariableNumberUnsignedLongBlock || tb instanceof VariableNumberDoubleBlock)) {
            throw new BlockException(this.blockId, uiMessageBundle.getString("ardublock.error_msg.number_var_slot"));
        }
        String varName = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        String startVal = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(2);
        String stopVal = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(3);
        String incVal = tb.toCode();
        String ret = "";
        ret = ret + "for(" + varName + " = " + startVal + "; \n" + startVal + "<=" + stopVal + "?" + varName + " <= " + stopVal + ":" + varName + " >= " + stopVal + "; \n" + startVal + "<=" + stopVal + "?" + varName + " = " + varName + " + " + incVal + ":" + varName + " = " + varName + " - " + incVal + ")\n{";
        for (TranslatorBlock translatorBlock = this.getTranslatorBlockAtSocket(4); translatorBlock != null; translatorBlock = translatorBlock.nextTranslatorBlock()) {
            ret = ret + translatorBlock.toCode();
        }
        ret = ret + "}\n";
        return ret;
    }
}

